#ifndef UNICODE
#define UNICODE
#endif
#include <windows.h>

// TCCの環境によっては定義されていない場合があるフラグを補完
#ifndef LOAD_LIBRARY_SEARCH_SYSTEM32
#define LOAD_LIBRARY_SEARCH_SYSTEM32 0x00000800
#endif

// 関数ポインタの型定義
typedef LPWSTR* (WINAPI *pCommandLineToArgvW)(LPCWSTR, int*);

// グローバル変数
WCHAR g_exe_path[MAX_PATH];
HFONT g_hFont = NULL;

// 実行ファイルの場所を特定する関数
void InitExeDir() {
    GetModuleFileNameW(NULL, g_exe_path, MAX_PATH);
    for (int i = lstrlenW(g_exe_path); i > 0; i--) {
        if (g_exe_path[i] == L'\\') { 
            g_exe_path[i+1] = L'\0'; 
            break; 
        }
    }
}

// ファイル読み込み (UTF-8)
void LoadFile(HWND hEdit, const WCHAR* path) {
    HANDLE hFile = CreateFileW(path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
    if (hFile != INVALID_HANDLE_VALUE) {
        DWORD size = GetFileSize(hFile, NULL);
        if (size > 0 && size != INVALID_FILE_SIZE) {
            char* buf = (char*)GlobalAlloc(GPTR, size + 1);
            DWORD read;
            if (buf && ReadFile(hFile, buf, size, &read, NULL)) {
                int lenW = MultiByteToWideChar(CP_UTF8, 0, buf, size, NULL, 0);
                WCHAR* bufW = (WCHAR*)GlobalAlloc(GPTR, (lenW + 1) * sizeof(WCHAR));
                if (bufW) {
                    MultiByteToWideChar(CP_UTF8, 0, buf, size, bufW, lenW);
                    SetWindowTextW(hEdit, bufW);
                    GlobalFree(bufW);
                }
            }
            if (buf) GlobalFree(buf);
        }
        CloseHandle(hFile);
    }
}

// メインウィンドウの処理
LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp) {
    static HWND hEdit;
    
    if (msg == WM_CREATE) {
        // エディタ作成
        hEdit = CreateWindowExW(0, L"EDIT", L"", 
            WS_CHILD | WS_VISIBLE | WS_VSCROLL | ES_MULTILINE | ES_AUTOVSCROLL | ES_WANTRETURN, 
            0, 0, 0, 0, hwnd, NULL, NULL, NULL);
        
        // フォント設定 (MSゴシック 22px)
        g_hFont = CreateFontW(22, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, 
            DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, 
            DEFAULT_QUALITY, FIXED_PITCH | FF_MODERN, L"MS Gothic");
        SendMessageW(hEdit, WM_SETFONT, (WPARAM)g_hFont, 1);

        // 【安全性向上】shell32.dllをシステムフォルダからのみ安全にロード
        HMODULE hShell = LoadLibraryExW(L"shell32.dll", NULL, LOAD_LIBRARY_SEARCH_SYSTEM32);
        if (hShell) {
            pCommandLineToArgvW pArgvW = (pCommandLineToArgvW)GetProcAddress(hShell, "CommandLineToArgvW");
            if (pArgvW) {
                int argc;
                LPWSTR* argv = pArgvW(GetCommandLineW(), &argc);
                if (argv) {
                    if (argc > 1) LoadFile(hEdit, argv[1]);
                    LocalFree(argv);
                }
            }
            FreeLibrary(hShell);
        }
        return 0;
    }

    if (msg == WM_SIZE) { 
        MoveWindow(hEdit, 0, 0, LOWORD(lp), HIWORD(lp), 1); 
        return 0; 
    }

    if (msg == WM_SETFOCUS) { 
        SetFocus(hEdit); 
        return 0; 
    }

    if (msg == WM_DESTROY) {
        int lenW = GetWindowTextLengthW(hEdit);
        if (lenW > 0) {
            SYSTEMTIME st; 
            WCHAR fn[MAX_PATH], ts[128], head[16] = {0};
            GetLocalTime(&st);
            
            // ファイル名サニタイズ処理
            GetWindowTextW(hEdit, head, 6); // 終端含め6文字分取得
            for(int i = 0; i < 5; i++) {
                if(head[i] < 32 || wcschr(L"\\/:*?\"<>|", head[i])) 
                    head[i] = L'_';
            }

            // ファイル名生成: [先頭5文字]_[日時].txt
            wsprintfW(ts, L"%s_%04d%02d%02d_%02d%02d%02d.txt", head, 
                st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond);
            lstrcpyW(fn, g_exe_path); 
            lstrcatW(fn, ts);
            
            // ファイル書き出し
            HANDLE hF = CreateFileW(fn, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 0, NULL);
            if (hF != INVALID_HANDLE_VALUE) {
                WCHAR* bufW = (WCHAR*)GlobalAlloc(GPTR, (lenW + 1) * sizeof(WCHAR));
                if (bufW) {
                    GetWindowTextW(hEdit, bufW, lenW + 1);
                    int len8 = WideCharToMultiByte(CP_UTF8, 0, bufW, lenW, NULL, 0, NULL, NULL);
                    char* buf8 = (char*)GlobalAlloc(GPTR, len8);
                    if (buf8) {
                        WideCharToMultiByte(CP_UTF8, 0, bufW, lenW, buf8, len8, NULL, NULL);
                        DWORD written; 
                        WriteFile(hF, buf8, len8, &written, NULL);
                        GlobalFree(buf8);
                    }
                    GlobalFree(bufW);
                }
                CloseHandle(hF);
            } else {
                // 保存失敗時の警告（管理者権限が必要な場所に置かれた場合など）
                MessageBoxW(NULL, L"ファイルを保存できませんでした。\n書き込み権限のある場所に移動して使用してください。", 
                    L"保存エラー", MB_OK | MB_ICONERROR | MB_SYSTEMMODAL);
            }
        }
        if (g_hFont) DeleteObject(g_hFont);
        PostQuitMessage(0); 
        return 0;
    }
    return DefWindowProcW(hwnd, msg, wp, lp);
}

// エントリポイント
int WINAPI WinMain(HINSTANCE hI, HINSTANCE hP, LPSTR lpC, int nS) {
    WNDCLASSW wc = {0}; 
    HWND hn; 
    MSG m;
    
    InitExeDir();
    
    wc.lpfnWndProc = WndProc; 
    wc.hInstance = hI; 
    wc.lpszClassName = L"E";
    wc.hCursor = LoadCursorW(NULL, (LPCWSTR)IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
    
    if (!RegisterClassW(&wc)) return 0;
    
    hn = CreateWindowExW(0, L"E", L"Slim Editor", 
        WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, 600, 400, NULL, NULL, hI, NULL);
    
    if (!hn) return 0;

    while (GetMessageW(&m, NULL, 0, 0)) {
        // Escキーで閉じる（保存処理が走る）
        if (m.message == WM_KEYDOWN && m.wParam == VK_ESCAPE) {
            DestroyWindow(hn);
        }
        TranslateMessage(&m); 
        DispatchMessageW(&m);
    }
    return (int)m.wParam;
}